/** @file   objectivenote.cpp
 * @brief   Implementation of ObjectiveNote - class.
 * @version $Revision: 1.3 $
 * @author  Tomi Lamminsaari
 */

#include "objectivenote.h"
#include "GfxManager.h"
#include "eng2d.h"
using std::string;

namespace WeWantWar {

/** Constructor
 */
ObjectiveNote::ObjectiveNote( int x, int y, int w, int h, const string& txt ) :
  OverlayItem( x, y, w, h ),
  m_content( txt ),
  m_state( STATE_FADEIN ),
  m_maxOpa( 200 )
{
  m_stateDurations[ STATE_FADEIN ] = 70;
  m_stateDurations[ STATE_VISIBLE ] = 190;
  m_stateDurations[ STATE_FADEOUT ] = 70;
  m_stateDurations[ STATE_HIDDEN ] = 1400;
  m_counter = m_stateDurations[ STATE_FADEIN ];
  
  this->updateBackgroundBuffer();
  this->opacity( 0 );
}



/** Destructor
 */
ObjectiveNote::~ObjectiveNote()
{
}


/** The update method
 */
void ObjectiveNote::update()
{
  m_counter -= 1;
  if ( m_counter < 0 ) {
    m_state += 1;
    if ( m_state == STATE_RESTART ) {
      m_state = STATE_FADEIN;
    }
    m_counter = m_stateDurations[ m_state ];
  }
  
  switch ( m_state ) {
    case ( STATE_FADEIN ): {
      OverlayItem::OpacityVal v = this->opacity();
      v += 2;
      this->opacity( v );
      break;
    }
    case ( STATE_VISIBLE ): {
      break;
    }
    case ( STATE_FADEOUT ): {
      OverlayItem::OpacityVal v = this->opacity();
      v -= 2;
      this->opacity( v );
      break;
    }
    case ( STATE_HIDDEN ): {
      this->opacity( 0 );
      break;
    }
  }
}



/** Sets the durations of the states
 */
void ObjectiveNote::setTimers( int fadein, int visible, int fadeout, int hidden )
{
  m_stateDurations[ STATE_FADEIN ] = fadein;
  m_stateDurations[ STATE_VISIBLE ] = visible;
  m_stateDurations[ STATE_FADEOUT ] = fadeout;
  m_stateDurations[ STATE_HIDDEN ] = hidden;
}


/** Updates the background buffer.
 */
void ObjectiveNote::updateBackgroundBuffer()
{ 
  BITMAP* pB = this->getBuffer();
  if ( pB == 0 ) {
    return;
  }
  FONT* pF = GfxManager::objectiveFont->al_FONT();
  if ( pF == 0 ) {
    return;
  }
  clear_to_color( pB, makecol(120,120,120) );
  vline( pB, 0, 0, pB->h, makecol(64,64,64) );
  vline( pB, pB->w, 0, pB->h, makecol(160,160,160) );
  hline( pB, 0, 0, pB->w, makecol(160,160,160) );
  hline( pB, 0, pB->h-1, pB->w-1, makecol(64,64,64) );
  
  int c = makecol( 230,230,230 );
  textout_centre_ex(pB, pF, m_content.c_str(), (pB->w/2), 2, c, -1 );
  
}

} // end of namespace
